#include "symtab.h"
#include "dtype.h"
#include "symbol.h"
#include "coff.h"
#include "core.h"
SRCFILE("coffsymtab.c")

int ccdemangle(char**,char* =0,int =0);

static void
revmemcpy( register char *to, register char *from, register int count )
{
	to += (count-1);
	from += (count-1);
	while( count-- )
		*to-- = *from--;
}

DType CoffSymTab::chain(int t, SymEnt *s)
{
	DType d;

	trace( "%d.chain(0%o,%d) %s", this, t, s, PccName(t) );
	if( t&TMASK ){
		d.pcc = t&TMASK;
		d.univ = new DType;
		*(d.ref()) = chain(DECREF(t), s);
	} else {
		if (!t)
			t = INT;
		d.pcc = t;
		if( (t==STRTY||t==ENUMTY||t==UNIONTY) )
			d.univ = s->numaux()
			       ? idtosym(U_UTYPE, entry(s->tagndx())->id())
			       : 0;
	}
	return d;
}

DType CoffSymTab::gatherdtype(SymEnt *s)
{
	DType d, *dp;
	int i = 0;

	trace( "%d.gatherdtype(%d)", this, s );
	d = chain(s->desc(),s);
	for( dp = &d; dp; dp = dp->ref() )
		if( dp->isary() )
			dp->dim = s->dimen(i++);
	trace( "%s", d.text() );
	return d;
}

CoffSymTab::CoffSymTab(class Core* c,int fd,SymTab *s,long r):SymTab(c,fd,s,r)
{
	fhdr = new filehdr;
	ahdr = new aouthdr;
}

CoffSymTab::~CoffSymTab()
{
	delete fhdr;
	delete ahdr;
}

char *CoffSymTab::gethdr()
{
	int i;
	scnhdr shdr;
	trace( "%d.getheader()", this );	OK( "CoffSymTab::gethdr" );
	if( lseek( fd, 0L, 0 ) == -1
	 || !ReadOK(fd, (char*)fhdr, sizeof *fhdr)
	 || (fhdr->f_opthdr && !ReadOK(fd, (char*)ahdr, sizeof *ahdr )) )
		return SysErr( "symbol table: " );
	_magic = fhdr->f_magic;
	entries = fhdr->f_nsyms;
	for( i = 0; i<fhdr->f_nscns; ++i )
		if( !ReadOK(fd, (char*)&shdr, sizeof(scnhdr) ) )
			return "section header error";
	return 0;
}

char *CoffSymTab::gettbl()
{
	trace( "%d.gettbl()" ); OK("CoffSymTab::gettbl");
	symoff = (SymEnt*)fhdr->f_symptr;
	if( I_COFFENTRYSIZE*2 != sizeof(SymEnt) ) abort();
	base = new SymEnt[(entries+1)/2];
	if( lseek(fd,(long)symoff,0) == -1
	 || !ReadOK(fd, (char*)base, (int)entries*COFFENTRYSIZE) ){
		delete base; base = 0;
		return SysErr( "symbol table: " );
	}
	// adjust table to account for internal representation padding
	char *from;
	char *to;
	for( long i = entries-1; i != 0; i-- ){
		from = (char*)base + (i * COFFENTRYSIZE);
		to   = (char*)base + (i * I_COFFENTRYSIZE);
		revmemcpy( to, from, COFFENTRYSIZE );
	}
	if( !ReadOK(fd, (char*)&strsize, 4) ){ // no extended strings
		strsize = 0;
		return 0;
	}
	strings = new char[strsize];
	if( lseek(fd, -4, 1) == -1 || !ReadOK(fd, strings, (int)strsize) ){
		delete strings; strings = 0;
		delete base; base = 0;
		return SysErr( "strings table: " );
	}
	strcpy( strings, "???" );	/* zero string index */
	return 0;
}

/* inline eventually */
SymEnt *CoffSymTab::entry(long i)
	{ return (SymEnt*) ((long)base + i*I_COFFENTRYSIZE); }

Source *CoffSymTab::tree()
{
	SymEnt	*s, *s2, *fsym = 0;
	Source	*src = 0;
	Func	*func;
	Block	*fake = fakeblk();
	Var	*glb, *fst = 0;
	long	inasrc = 0, i = 0, j, skip = 0;
	UType	*u;
	char	*id;
	DType	*d;
	int	l;
	int	dr, demangled;
	char	*fname;

	trace( "%d.tree()", this ); OK(0);

	if( _warn = gettbl() ) return 0;
	
	func = new Func(this, "start", 0, 0);
	func->range.lo = relocation;
	func->_blk = fake;
	func->type.pcc = CHAR;		// why is this CHAR? cf ed8
	glb = globregs(_blk, _core->nregs() );
	while( i < entries ){
		s = entry(i);
		s->mkid(strings);
		switch( s->sclass() ){
		case C_STRTAG:
		case C_UNTAG:
		case C_ENTAG:
			skip = s->endndx();
			id = s->id();
			ccdemangle(&id);
			if( u = (UType*) idtosym(U_UTYPE,id) ){
				if( u->range.lo == s->size() )
					break;
			}
			++UTypeStubs;
			u = new UType(this, i, skip-1, id);
			u->range.lo = s->size();
			u->type.pcc = s->desc();
			u->type.univ = u;
			u->rsib = utype;
			utype = u;
			break;
		case C_EXT:
		case C_STAT:
			id = s->id();
			dr = ccdemangle(&id);
			if (ISFTN(s->desc())) {
				if (inasrc) {
					fsym = s;
					fname = id;
					demangled = dr;
				} else {
					if (idtosym(U_FUNC, id, 0))
						break;
					func = new Func(this,id,0,0);
					func->range.lo = s->value()+relocation;
					func->_blk = fake;
					func->type = gatherdtype(s);
				}
			} else
				if (s->scnum() == 1) { // In .text segment
					if (idtosym(U_FUNC, id, 0))
						break;
					func = new Func(this,id,0,0);
					func->range.lo = s->value()+relocation;
					func->_blk = fake;
					d = new DType;
					d->pcc = LONG;
					func->type = d->incref();
					func->type.pcc = FTN;
				} else if (s->sclass()== C_EXT)
					gathervar( s, &glb, _blk, U_GLB );
				else {
					if( !inasrc || !src || !src->blk )
						break;
					gathervar( s, &fst, src->blk, U_FST );
				}
			break;
		case C_FILE:
			id = s->filename();		/* un-cfront */
			inasrc = 0;
			// Throw away files without functions
			for (j = i+s->numaux()+1; j < entries; ) {
				s2 = entry(j);
				switch (s2->sclass()) {
				case C_FCN:
					inasrc = 1;
					// Fall through
				case C_FILE:
					goto out;
				case C_STRTAG:
				case C_UNTAG:
				case C_ENTAG:
					j = s2->endndx();
					break;
				default:
					j += s2->numaux() + 1;
					break;
				}
			}
out:			if (!inasrc)
				break;
			l = strlen(id);
			if( id[l-1]=='i' && id[l-2]=='.' )
				id = sf("%0.*sc", l-1, id );
			src = new Source(this, src, id, 0);
			func = 0;
			fst = 0;
			break;
		case C_FCN:
			if( !inasrc || !src ) break;
			if( strcmp(s->id(), ".bf") || !fsym )
				break;
			++FunctionStubs;
			func = new Func(this, fname, src, s->lnno());
			if (demangled) {
				fname = fsym->id();
				ccdemangle(&fname, 0, 1);
				func->namewithargs = fname;
			}
			skip = fsym->endndx();
			func->range.lo = fsym->value()+relocation;
			func->range.hi = func->range.lo+fsym->fsize();
			func->lnnoptr = fsym->lnnoptr();
			if( func->lines.lo > 30000 )	/* C++/coff bug */
				func->lnnoptr = 0;
			func->regsave = -1;
			func->lines.hi = func->lines.lo+entry(skip-2)->lnno()-1;
			func->begin = i;
			func->size = skip-i;
			func->type = gatherdtype(fsym);
			break;
		default:
			break;
		}
		i = skip ? skip : i+s->numaux()+1;
		skip = 0;
	}
	while( src && src->lsib ) src = (Source*) src->lsib;
	return src;
}

void CoffSymTab::gathervar( SymEnt *s, Var **v, Block *b, UDisc d )
{
	trace( "%d.gathervar(%d,%d,%d,%d)", s, v, b, d ); VOK;
	IF_LIVE( !v ) return;
	if( s->id()[0] == '.' ) return;			/* .text, .bss, .data */
	*v = new Var( this, b, *v, d, s->id() );
	if( b && !b->var ) b->var = *v;
	(*v)->type = gatherdtype(s);
	(*v)->range.lo = s->value();
	if( d == U_GLB || d == U_STA || d == U_FST)
		(*v)->range.lo += relocation;
}

Block *CoffSymTab::gatherfunc(Func *func)
{
	Block *ablk, *lblk;
	Var *arg = 0, *lcl = 0;
	Stmt *stmt = 0;
	long i, bf = func->begin, ef = bf+func->size;
	SymEnt *s;

	++FunctionGathered;
	trace( "%d.gatherfunc(%d,%d)", this, bf, size );	OK(0);
	ablk = new Block( this, 0, 0, sf("{%s.args}",func->text()) );
	lblk = new Block( this, ablk, 0, sf("{%s.lcls}",func->text()) );
	ablk->child = lblk;
	for( i = bf; i < ef; i += s->numaux()+1 ){
		s = entry(i);
		s->mkid(strings);
		switch( s->sclass() ){
		case C_STAT:
			gathervar( s, &lcl, lblk, U_STA );
			break;
		case C_REG:
			gathervar( s, &lcl, lblk, U_REG );
			break;
		case C_REGPARM:
			gathervar( s, &arg, ablk, U_REG );
			break;
		case C_ARG:
			gathervar( s, &arg, ablk, U_ARG );
			break;
		case C_AUTO:
			gathervar( s, &lcl, lblk, U_AUT );
			break;
		}
	}
	LineNo lines[MAXLINENO];
	register struct LineNo *l = lines;
	int nolines = (int)((long)symoff - func->lnnoptr) / LINENOSIZE;
	if (nolines > MAXLINENO)
		nolines = MAXLINENO;
	if( func->lnnoptr && lseek(fd, func->lnnoptr, 0) != -1
	 && ::read(fd, (char*)lines, nolines*LINENOSIZE) >= 2*LINENOSIZE ){
		// adjust the alignment...
		char	*to, *from;
		for( i = nolines-1; i > 0; i-- ){
			from = (char *)lines + i*LINENOSIZE;
			to   = (char *)lines + i*I_LINENOSIZE;
			revmemcpy( to, from, LINENOSIZE );
		}
		for( i = 1; i < nolines; ++i ){
			l = (LineNo*) ((long)lines + i*I_LINENOSIZE);
			if( l->line == 0 ) break;
			l->line += (short)func->lines.lo-1;
			l->addr += relocation;
			while( stmt && stmt->lineno > l->line ){
				stmt = (Stmt*) stmt->lsib;
				if( stmt ) stmt->rsib = 0;
				else ablk->stmt = 0;
			}
			if( stmt && stmt->lineno == l->line )
				continue;
			if( stmt ) stmt->range.hi = l->addr;
			stmt = new Stmt(this,lblk,stmt);
			if( !ablk->stmt ) ablk->stmt = stmt;
			stmt->lineno = l->line;
			stmt->range.lo = l->addr;
			stmt->range.hi = func->range.hi;
			if( !ablk->range.lo ) ablk->range.lo = stmt->range.lo;
			ablk->range.hi = stmt->range.lo;
		}
	}
	uncfront( ablk->var, (char *)0 );
	uncfront( lblk->var, (char *)0 );
	return ablk;
}

Var *CoffSymTab::gatherutype(UType *u)
{
	SymEnt	*s;
	Var	*first = 0, *v = 0;
	long	i, strtag = u->begin, eos = strtag+u->size;

	++UTypeGathered;
	trace( "%d.gatherutype(%d,%d)", this, strtag, u->size );
	for( i = strtag; i < eos; i += s->numaux()+1 ){
		s = entry(i);
		s->mkid(strings);
		switch( s->sclass() ){
		case C_FIELD:
		case C_MOS:
		case C_MOU:
		case C_MOE:
			gathervar(s, &v, 0, U_MOT);
			if( !first ) first = v;
			if( s->sclass()==C_FIELD ){
				v->range.lo += (v->type.dim = s->fldsize());
				int lo5 = int(v->range.lo&31);
				v->range.lo &= ~31;
				v->range.lo |= 32-lo5;
				switch( s->desc() ){
				case INT:	v->type.pcc = BITS; break;
				case UNSIGNED:	v->type.pcc = UBITS;
				}
			}
			break;
		case C_EOS:
			goto Out;
		}
	}
Out:
	uncfront(first, u->_text);
	return first;
}
